<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

class FeatureProduct
{
	/** @var int */
	public $idProduct;

	/** @var int|string */
	public $idFeature;

	/** @var int|string */
	public $idFeatureValue;

	/** @var int */
	public $position;

	/** @var int */
	public $valuePosition;

	/** @var string */
	public $name;

	/** @var string */
	public $value;

	public ?string $image = null;

	public bool $showAsTag = false;

	public ?string $tagTextColor = null;

	public ?string $tagBgColor = null;

	public ?string $productTabTitle = null;

	public ?string $tagText = null;

	public ?string $shortDescription = null;

	public ?string $longDescription = null;

	public ?string $moreLink = null;

	public function getKey(): string { return $this->idFeature . '-' . $this->idFeatureValue; }

	public function getTagStyle(): string
	{
		$arr = [];

		if ($this->tagTextColor)
			$arr[] = 'color:' . $this->tagTextColor;
		if ($this->tagBgColor)
			$arr[] = 'background-color:' . $this->tagBgColor;

		return implode(';', $arr);
	}
}
