<?php declare(strict_types=1);

namespace EshopCatalog\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\FrontModule\Model\Dao;
use EshopCatalog\Model\Entities\ProductVideo;
use Nette\Localization\Translator;

class ProductVideos
{
	protected EntityManagerDecorator $em;
	protected Translator $translator;
	
	/** @var Dao\Video[] */
	protected array $cVideos = [];

	public function __construct(EntityManagerDecorator $em, Translator $translator)
	{
		$this->em = $em;
		$this->translator = $translator;
	}

	/**
	 * @param array $ids
	 *
	 * @return Dao\Video[][]
	 */
	public function getVideos(array $ids): array
	{
		$whereIds = [];
		$result   = [];
		$locale   = $this->translator->getLocale();

		foreach ($ids as $id) {
			if (isset($this->cVideos[$id]))
				$result[$id] = $this->cVideos[$id];
			else
				$whereIds[] = $id;
		}

		if (!empty($whereIds)) {
			$qb = $this->em->getRepository(ProductVideo::class)->createQueryBuilder('pv')
						   ->select('IDENTITY(pv.product) as product, pv.title, pv.url')
						   ->where('pv.product IN (:ids)')
						   ->andWhere('pv.lang IS NULL OR pv.lang = :lang')
						   ->setParameters([
							   'ids'  => $whereIds,
							   'lang' => $locale,
						   ]);

			foreach ($qb->getQuery()->getArrayResult() as $row) {
				$this->cVideos[$row['product']][] = $this->fillDao($row);
			}

			foreach ($whereIds as $id) {
				if (!isset($this->cVideos[$id]))
					$this->cVideos[$id] = [];
				else
					$result[$id] = $this->cVideos[$id];
			}
		}

		return $result;
	}

	protected function fillDao(array $data): Dao\Video
	{
		return new Dao\Video($data['title'], $data['url']);
	}

}