<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use EshopCatalog\Model\PseudoWarehouse;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopCatalog\Model\Config;
use EshopOrders\FrontModule\Model\Event\OrderEvent;

class OrderPseudoWarehouseSubscriber implements EventSubscriberInterface
{
	protected PseudoWarehouse $pseudoWarehouse;

	public function __construct(PseudoWarehouse $pseudoWarehouse)
	{
		$this->pseudoWarehouse = $pseudoWarehouse;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 100],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		if (!Config::load('pseudoWarehouse'))
			return;

		$data = [];
		foreach ($event->order->getOrderItems() as $v) {
			$data[$v->getProductId()] = $v->getQuantity();
		}

		$this->pseudoWarehouse->lowerQuantities($data);
	}
}
