<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__feature_value", indexes={@ORM\Index(name="published", columns={"id", "is_published"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureValueListener", "Core\Model\Entities\TranslateListener"})
 */
class FeatureValue
{
	use TId;
	use TTranslateListener;

	/**
	 * @var Feature
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="id", cascade={"persist"})
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $feature;

	/**
	 * @var FeatureValueTexts
	 * @ORM\OneToMany(targetEntity="FeatureValueTexts", mappedBy="id", indexBy="lang")
	 */
	protected $featureValueTexts;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=true, options={"default"=0})
	 */
	public $isPublished;

	/**
	 * @ORM\Column(name="show_as_tag", type="smallint", nullable=false, options={"default"=0})
	 */
	public int $showAsTag = 0;

	/**
	 * @ORM\Column(name="more_link", type="string", nullable=true)
	 */
	public ?string $moreLink = null;

	/**
	 * @ORM\Column(name="image", type="string", nullable=true)
	 */
	public ?string $image = null;

	/**
	 * @ORM\Column(name="tag_text_color", type="string", nullable=true)
	 */
	public ?string $tagTextColor = null;

	/**
	 * @ORM\Column(name="tag_bg_color", type="string", nullable=true)
	 */
	public ?string $tagBgColor = null;

	/**
	 * FeatureValue constructor.
	 */
	public function __construct()
	{
		$this->featureValueTexts = new ArrayCollection();
		$this->isPublished       = 1;
		$this->setPosition(-1);
	}

	public function addFeatureValueText($lang)
	{
		$this->featureValueTexts->set($lang, new FeatureValueTexts($this, $lang));
	}

	/**
	 * @param string|null $lang
	 *
	 * @return null
	 */
	public function getFeatureValueText(?string $lang = null) { return $this->featureValueTexts[$lang ?: $this->locale] ?: null; }

	/**
	 * @return ArrayCollection|FeatureValueTexts[]
	 */
	public function getFeatureValueTexts() { return $this->featureValueTexts; }

	public function setFeature(Feature $feature)
	{
		$this->feature = $feature;
	}

	public function setFeatureValueText(FeatureValueTexts $featureValueTexts)
	{
		$this->featureValueTexts->set($featureValueTexts->getLang(), $featureValueTexts);
	}

	public function setTexts(array $texts)
	{
		$this->featureValueTexts = new ArrayCollection($texts);
	}

	public function getFeature()
	{
		return $this->feature;
	}

	/******
	 * === Position
	 */

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition(int $position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition() { return $this->position; }
}

