<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class ProductsFeedEvent extends Event
{
	public ?string $customerName;

	public array $data;

	public function __construct(array &$data, ?string $customerName)
	{
		$this->data         = &$data;
		$this->customerName = $customerName;
	}
}
