<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\Model\Entities\ProductVariant;

class VariantsHelper
{
	protected EntityManagerDecorator $em;

	protected array $cLoaded = [];

	protected bool $allLoaded = false;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function getAllVariants()
	{
		if (!$this->allLoaded) {
			$this->allLoaded = true;
			$map             = [];

			foreach ($this->em->createQueryBuilder()->from(ProductVariant::class, 'pv')
				         ->select('IDENTITY(pv.product) as id, pv.isDefault, pv.variantId')
				         ->orderBy('pv.isDefault', 'DESC')
				         ->getQuery()->getScalarResult() as $row) {
				if ($row['isDefault'] === 1) {
					$this->cLoaded[$row['id']] = [];
					$map[$row['variantId']]    = $row['id'];
				} else {
					$this->cLoaded[$map[$row['variantId']]][] = $row['id'];
				}
			}
		}

		return $this->cLoaded;
	}

	public function getProductVariants($productId)
	{
		$ids    = is_array($productId) ? $productId : [$productId];
		$loaded = [];
		$where  = [];

		foreach ($ids as $id) {
			if (isset($this->cLoaded[$id]))
				$loaded[$id] = $this->cLoaded[$id];
			else {
				$where[]            = $id;
				$this->cLoaded[$id] = [];
			}
		}

		if ($where) {
			$variantIds = [];
			foreach ($this->em->createQueryBuilder()
				         ->select('IDENTITY(pv.product) as prod, pv.variantId')
				         ->from(ProductVariant::class, 'pv')
				         ->where('pv.product IN (:prod)')
				         ->setParameter('prod', $where)
				         ->getQuery()->getArrayResult() as $row) {
				$variantIds[$row['variantId']] = $row['prod'];
			}

			if ($variantIds) {
				foreach ($this->em->createQueryBuilder()->from(ProductVariant::class, 'pv')
					         ->select('IDENTITY(pv.product) as id, pv.variantId')
					         ->where('pv.variantId IN (:varId)')
					         ->andWhere('pv.isDefault = 0')
					         ->setParameter('varId', array_keys($variantIds))
					         ->getQuery()->getScalarResult() as $row) {
					$key                   = $variantIds[$row['variantId']];
					$this->cLoaded[$key][] = $row['id'];
					$loaded[$key][]        = $row['id'];
				}
			}
		}

		return is_array($productId) ? $loaded : $loaded[$productId];
	}
}
