document.addEventListener('DOMContentLoaded', () => {
	initCategoryFilter();
	initSiteSelect();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initSiteSelect();

		setTimeout(() => {
			initCategoryFilter();
		}, 5000);
		initCategoryFilter();
	});

	global.naja.addEventListener('complete', e => {
		initCategoryFilter();
	});

	const categoryListUpdateSwitch = document.getElementById('category-list-update-switch__input');
	if (categoryListUpdateSwitch) {
		categoryListUpdateSwitch.addEventListener('change', e => {
			global.naja.makeRequest('post', categoryListUpdateSwitch.dataset.link, {
				val: categoryListUpdateSwitch.checked === true ? 1 : 0,
			}, {
				history: false,
			});
		})
	}

	document.addEventListener('click', e => {
		const target = e.target;

		if (target.dataset.siteident) {
			const btn = document.querySelector('.navbar.navbar--header a.navbar__link');

			let href = btn.href;
			href     = replaceQueryParam('site-ident', target.dataset.siteident, href);
			btn.href = href;
		}
	})
});

function replaceQueryParam(param, newval, search) {
	let regex = new RegExp("([?;&])" + param + "[^&;]*[;&]?");
	let query = search.replace(regex, "$1").replace(/&$/, '');

	return (query.length > 2 ? query + "&" : "?") + (newval ? param + "=" + newval : '');
}

const initSiteSelect = () => {
};

const initCategoryFilter = () => {
	let productsGridForm = document.getElementById('frm-productsGrid-grid-filter');

	if (!productsGridForm)
		return;

	productsGridForm.querySelectorAll('[name="filter[defaultCategory]"]:not(.init)').forEach(el => {
		el.classList.add('init');

		el.addEventListener('change', () => {
			let data = new FormData(el.form);
			global.naja.makeRequest('post', el.form.action, data);
		});
	});
};
