const initSearchForm = () => {
	const form = document.getElementById('autocomplete-form')
	const searchBox = document.querySelector('[data-autocomplete-box]')
	const searchInput = form?.querySelector('[name=q]')
	const searchResults = searchBox?.querySelector('[data-autocomplete-results]')
	const formSubmit = form.querySelector('[type=submit]')

	if (!searchInput || !searchBox || !searchResults || !formSubmit) {
		return
	}

	document.addEventListener('headerSearch:shown', e => searchInput.focus())

	searchInput.addEventListener('input', e => {
		const val = e.target.value
		if (!val) {
			searchResults.style.display = 'none'
			return
		}

		searchResults.style.display = null;

		fetch(window.personalizationAutocomplete.apiUrl.replace('__VAL__', val))
			.then(res => res.json())
			.then(data => {
				const wrapper = document.querySelector('[data-autocomplete-results]')
				wrapper.innerHTML = ''

				if (data.products.length || data.categories.length) {
					const container = document.createElement('div')
					container.classList.add('search__container')

					const products = data.products
					const categories = data.categories
					let xOfY = null

					// ----------------------------------- categories
					const categoriesContainer = document.createElement('div')

					xOfY = window.personalizationAutocomplete.texts.xOfY.replace('%x%', categories.length).replace('%y%', data.totalCategories)
					categoriesContainer.insertAdjacentHTML('afterbegin', `<h2>${window.personalizationAutocomplete.texts.categoriesFound} <span class="badge">${data.totalCategories > categories.length ? xOfY : categories.length}</span></h2>`)
					const categoriesResultElement = document.createElement('div')
					categoriesResultElement.classList.add('categories-result')

					const sectionAddedByProductPane = document.createElement('div')
					sectionAddedByProductPane.classList.add('section__pane')
					const sectionPrimaryPane = document.createElement('div')
					sectionPrimaryPane.classList.add('section__pane')

					let categoriesAddedByProductCount = 0
					let categoriesPrimaryCount = 0
					categories.forEach((el, i) => {
						const a = document.createElement('a')
						a.classList.add('item')
						a.classList.add('item--category')

						const img = el.imagePreviews.small[0]

						if (img) {
							a.insertAdjacentHTML('beforeend', `<div class="item__image"><img srcset="${img} 450w" src="${img}" alt="${el.title}" /></div>`)
						} else {
							a.insertAdjacentHTML('beforeend', `<div class="item__image"><div></div></div>`)
						}

						a.insertAdjacentHTML('beforeend', `<div class="item__info"><div class="item__title"><h3>${el.title}</h3></div></div>`)

						if (el.tags.addedByProduct) {
							a.href = window.personalizationAutocomplete.searchUrl.replace('__CAT_VAL__', el.databaseId).replace('__VAL__', val)
							categoriesAddedByProductCount++
							sectionAddedByProductPane.insertAdjacentElement('beforeend', a)
						} else {
							a.href = el.link
							categoriesPrimaryCount++
							sectionPrimaryPane.insertAdjacentElement('beforeend', a)
						}
					})

					const sectionPrimary = document.createElement('div')
					sectionPrimary.classList.add('section')
					sectionPrimary.insertAdjacentHTML('beforeend', '<div class="section__title"><span></span></div>')
					sectionPrimary.insertAdjacentElement('beforeend', sectionPrimaryPane)

					if (categoriesPrimaryCount) {
						categoriesResultElement.insertAdjacentElement('beforeend', sectionPrimary)
					}

					const sectionAddedByProduct = document.createElement('div')
					sectionAddedByProduct.classList.add('section')
					sectionAddedByProduct.insertAdjacentHTML('beforeend', '<div class="section__title"><span>Zboží v kategorii</span></div>')
					sectionAddedByProduct.insertAdjacentElement('beforeend', sectionAddedByProductPane)

					if (categoriesAddedByProductCount) {
						categoriesResultElement.insertAdjacentElement('beforeend', sectionAddedByProduct)
					}

					categoriesContainer.insertAdjacentElement('beforeend', categoriesResultElement)
					container.insertAdjacentElement('beforeend', categoriesContainer)

					// ----------------------------------- products
					const productsContainer = document.createElement('div')

					xOfY = window.personalizationAutocomplete.texts.xOfY.replace('%x%', products.length).replace('%y%', data.totalProducts)

					const productsHeader = document.createElement('div')
					productsHeader.classList.add('d-flex')
					productsHeader.classList.add('justify-content-between')

					const developedByLink = document.createElement('a')
					developedByLink.classList.add('d-flex')
					developedByLink.classList.add('developed-by')
					developedByLink.href = window.personalizationAutocomplete.texts.developedByUrl
					developedByLink.target = '_blank'
					developedByLink.innerHTML = `<span class="mr-4">${window.personalizationAutocomplete.texts.developedByText}</span>` + '<img width="64" height="19" loading="lazy" src="https://assets.pshk.cz/logo/logo-pshk.svg" />'

					productsHeader.insertAdjacentElement('afterbegin', developedByLink)
					productsHeader.insertAdjacentHTML('afterbegin', `<h2>${window.personalizationAutocomplete.texts.productsFound} <span class="badge">${data.totalProducts > products.length ? xOfY : products.length}</span></h2>`)

					productsContainer.insertAdjacentElement('afterbegin', productsHeader)
					const productsResultElement = document.createElement('div')
					productsResultElement.classList.add('products-result')

					products.forEach((el, i) => {
						const a = document.createElement('a')
						a.href = el.link
						a.classList.add('item')
						a.classList.add('item--product')

						const img = el.imagePreviews.small[0]
						if (img) {
							a.insertAdjacentHTML('beforeend', `<div class="item__image"><img srcset="${img} 450w" src="${img}" alt="${el.title}" /></div>`);
						} else {
							a.insertAdjacentHTML('beforeend', `<div class="item__image"><div></div></div>`);
						}
						a.insertAdjacentHTML('beforeend', `<div class="item__info"><div class="item__title"><h3>${el.title}</h3></div><div class="item__prices"><span class="item__price">${el.price} ${window.personalizationAutocomplete.texts.currency}</span><span class="item__price-label">${window.personalizationAutocomplete.texts.priceWithTax}</span></div></div>`)

						productsResultElement.insertAdjacentElement('beforeend', a)
					})

					productsContainer.insertAdjacentElement('beforeend', productsResultElement)

					const showMoreButtonWrapper = document.createElement('div')
					showMoreButtonWrapper.classList.add('d-flex')
					showMoreButtonWrapper.classList.add('controls-bar')

					if (products.length || categories.length) {
						const showMoreButton = document.createElement('button')
						showMoreButton.innerText = window.personalizationAutocomplete.texts.showMore
						showMoreButton.classList.add('primary-bg-color')
						showMoreButton.classList.add('btn')
						showMoreButton.classList.add('mx-auto')
						showMoreButton.addEventListener('click', e => formSubmit.click())
						showMoreButtonWrapper.insertAdjacentElement('beforeend', showMoreButton)
					}

					container.insertAdjacentElement('beforeend', productsContainer)
					wrapper.insertAdjacentElement('beforeend', container)
					wrapper.insertAdjacentElement('beforeend', showMoreButtonWrapper)

				} else {
					wrapper.insertAdjacentHTML('afterbegin', `<h2 class="justify-content-center">${window.personalizationAutocomplete.texts.productsNotFoud}`)
				}

				const developedByMobileLink = document.createElement('a')
				developedByMobileLink.classList.add('d-flex')
				developedByMobileLink.classList.add('developed-by--mobile')
				developedByMobileLink.href = window.personalizationAutocomplete.texts.developedByUrl
				developedByMobileLink.target = '_blank'
				if (!data.products.length && !data.categories.length) {
					developedByMobileLink.classList.add('no-results')
				}
				developedByMobileLink.innerHTML = `<span class="mr-4">${window.personalizationAutocomplete.texts.developedByText}</span>` + '<img width="64" height="19" loading="lazy" src="https://assets.pshk.cz/logo/logo-pshk.svg" />'

				const developedByWrapper = document.createElement('div')
				developedByWrapper.classList.add('d-flex')
				developedByWrapper.classList.add('justify-content-end')
				developedByWrapper.classList.add('mt-5')
				developedByWrapper.insertAdjacentElement('afterbegin', developedByMobileLink);
				wrapper.insertAdjacentElement('beforeend', developedByWrapper)
			})
	})

	document.addEventListener('click', e => {
		if (e.target.closest('[data-autocomplete-box]') && searchInput.value) {
			searchResults.style.display = null
		} else {
			searchResults.style.display = 'none'
		}
	})

	document.addEventListener('keydown', e => {
		if (e.key === 'Escape') {
			searchResults.style.display = 'none'
		}
	})
}

document.addEventListener('DOMContentLoaded', e => {
	initSearchForm()
})