import {checkMedia} from "core/js/utils/utilities";

document.addEventListener('DOMContentLoaded', e => {
	const mobileSizeForFilter = checkMedia(document.body.dataset.responsiveThresholdEshopFilter)

	document.addEventListener('click', e => {
		const target = e.target

		if (mobileSizeForFilter) {
			let el = target.closest('.filters__filter-val')
			if (el !== null) {
				e.preventDefault()

				global.naja.makeRequest('GET', el.href, {}, {
					history: true,
				});

				return
			}
		}
	})
})