<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopCatalog\Model\Entities\ProductPriceHistory;

class PriceHistoryGrid extends BaseControl
{
	public int $productId;

	public function __construct(
		int $productId
	)
	{
		$this->productId = $productId;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->em->getRepository(ProductPriceHistory::class)->createQueryBuilder('ph')
			->select('ph.id, ph.price, ph.created, ph.reason')
			->where('ph.product = :product')
			->setParameter('product', $this->productId)
			->orderBy('ph.created', 'ASC');

		$rows = [];
		foreach ($qb->getQuery()->getArrayResult() as $row) {
			$rows[$row['id']] = [
				'id'      => $row['id'],
				'price'   => $row['price'],
				'created' => $row['created'],
				'reason'  => $row['reason'],
			];
		}

		$grid->setDataSource(array_reverse($rows));

		$grid->addColumnText('price', 'eshopCatalog.priceHistory.price')
			->setRenderer(function(array $row) {
				return $row['price'] ? number_format((float) $row['price'], 2, ',', ' ') : '';
			})
			->setAlign('right');
		$grid->addColumnDateTime('created', 'eshopCatalog.priceHistory.setTo')->setFormat('j. n. Y H:i');
		$grid->addColumnText('reason', 'eshopCatalog.priceHistory.reason')->setRenderer(function(array $row) {
			$translate = $this->t('eshopCatalog.priceHistory.reasonType.' . $row['reason']);
			if ($row['reason'] !== $translate) {
				return $translate;
			}

			return $row['reason'];
		});

		return $grid;
	}
}
