<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\FormContainers\ProductChangePlanContainer;
use EshopCatalog\AdminModule\Model\Products;
use Nette\InvalidArgumentException;
use Nette\Utils\ArrayHash;

class ProductsChangePlanForm extends BaseControl
{
	private string                       $ids = '';
	protected Products                   $productServices;
	protected ProductChangePlanContainer $changePlanContainer;

	public function __construct(
		Products                   $products,
		ProductChangePlanContainer $changePlanContainer
	)
	{
		$this->productServices     = $products;
		$this->changePlanContainer = $changePlanContainer;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addComponent($this->changePlanContainer->getContainer(explode('-', $this->ids)), 'changePlan');

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		return true;
	}

	public function setProducts(?string $ids): void
	{
		if (!$ids) {
			throw new InvalidArgumentException;
		}

		$this->ids = $ids;
	}

}
