<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\FormContainers\ProductPaymentContainer;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Config;
use Nette\InvalidArgumentException;
use Nette\Utils\ArrayHash;

class ProductsPaymentsForm extends BaseControl
{
	private string                    $ids = '';
	protected Products                $productServices;
	protected ProductPaymentContainer $productPaymentContainer;

	public function __construct(
		Products                $products,
		ProductPaymentContainer $productPaymentContainer
	)
	{
		$this->productServices         = $products;
		$this->productPaymentContainer = $productPaymentContainer;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		if (!Config::load('product.allowModifyPayment', false)) {
			return $form;
		}

		$form->addHidden('produtcIds', $this->ids);
		$form->addComponent($this->productPaymentContainer->getContainer(true), 'payments');

		$form->addSaveCancelControl();
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$this->productPaymentContainer->saveData($values->payments, explode('-', $this->ids));
		$this->em->flush();

		$form->addCustomData('productIds', $this->ids);

		return true;
	}

	public function setProducts(?string $ids): void
	{
		if (!$ids) {
			throw new InvalidArgumentException;
		}

		$this->ids = $ids;
	}

}
