<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

class FeaturesFacade
{
	protected Features $features;
	protected FeatureValues $featureValues;

	public function __construct(Features $features, FeatureValues $featureValues)
	{
		$this->features      = $features;
		$this->featureValues = $featureValues;
	}

	public function getFlatTree(): array
	{
		$flat         = [];
		$featureTexts = $this->features->getOptionsForSelect();
		foreach ($this->featureValues->getOptionsForSelect() as $featureId => $values) {
			$flat[] = [
				'id'     => 'f' . $featureId,
				'name'   => $featureTexts[$featureId],
				'parent' => 0,
			];

			foreach ($values as $valueId => $value) {
				$flat[] = [
					'id'     => $featureId . '-' . $valueId,
					'name'   => $value,
					'parent' => 'f' . $featureId,
				];
			}
		}

		return $flat;
	}

}