<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization\Personalization;
use EshopCatalog\Model\Personalization\PersonalizationAccessControl;

class CrossSellProducts extends PersonalizationControl
{
	protected Personalization $personalization;
	protected PersonalizationAccessControl $personalizationAccessControl;

	public function __construct(
		Personalization $personalization,
		PersonalizationAccessControl $personalizationAccessControl
	)
	{
		$this->personalization = $personalization;
		$this->personalizationAccessControl = $personalizationAccessControl;
	}

	public function render(int $productId): void
	{
		$this->template->productIds = $this->personalization->getCrossSellProducts($productId);
		$this->template->render($this->getTemplateFile());
	}

	public function isAllowed(): bool
	{
		return $this->personalizationAccessControl->isCrossSellProductsAllowed();
	}

}