<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use Core\Model\UI\BaseControl;
use EshopCatalog\Model\Config;
use Nette\ComponentModel\IComponent;

abstract class PersonalizationControl extends BaseControl
{
	protected string $apiBaseUrl;
	protected string $apiToken;

	protected function attached(IComponent $presenter): void
	{
		parent::attached($presenter);

		$this->apiBaseUrl = (string) Config::load('personalization.baseApiUrl');
		$this->apiToken = (string) Config::load('personalization.apiToken');
	}

}