<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model;

use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class CacheService
{
	public Cache $defaultCache;
	public Cache $navigationCache;
	public Cache $productCache;
	public Cache $priceCache;
	public Cache $filterCache;
	public Cache $categoryCache;
	public Cache $documentsCache;
	public Cache $videosCache;
	public Cache $packagesCache;

	protected static array $cleaned = [];

	public function __construct(
		Storage $cacheStorage
	)
	{
		$this->defaultCache    = new Cache($cacheStorage, 'eshopCatalog');
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->productCache    = new Cache($cacheStorage, Products::CACHE_NAMESPACE);
		$this->priceCache      = new Cache($cacheStorage, Products::CACHE_PRICE_NAMESPACE);
		$this->filterCache     = new Cache($cacheStorage, FilterService::CACHE_NAMESPACE);
		$this->categoryCache   = new Cache($cacheStorage, Categories::CACHE_NAMESPACE);
		$this->documentsCache  = new Cache($cacheStorage, ProductDocuments::CACHE_NAMESPACE);
		$this->videosCache     = new Cache($cacheStorage, ProductVideos::CACHE_NAMESPACE);
		$this->packagesCache   = new Cache($cacheStorage, Packages::cacheNamespace);
	}

	public function clean(string $type, array $params): void
	{
		if (isset($params[Cache::TAGS])) {
			$tags   = $params[Cache::TAGS];
			$exists = self::$cleaned[$type] ?? [];

			if ($exists) {
				foreach ($tags as $kTag => $tag) {
					if (in_array($tag, $exists)) {
						unset($tags[$kTag]);
					} else {
						self::$cleaned[$type][] = $tag;
						$exists[]               = $tag;
					}
				}
			} else {
				self::$cleaned[$type] = $tags;
			}

			if ($tags) {
				$this->{$type . 'Cache'}->clean([Cache::TAGS => $tags]);
			}
		}
	}

	public function removeDocuments(array $productsIds): void
	{
		foreach ($productsIds as $id) {
			$this->documentsCache->remove('documents/' . $id);
		}
	}

	public function removeVideos(array $productsIds): void
	{
		foreach ($productsIds as $id) {
			$this->videosCache->remove('videos/' . $id);
		}
	}

	public function removePackage(array $packageIds): void
	{
		foreach ($packageIds as $id) {
			$this->videosCache->remove('package/' . $id);
		}
	}

}