<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Entities\Feature;

class FilterGroup
{
	public ?int    $id        = null;
	public ?string $type      = null;
	public ?string $name      = null;
	public ?string $valueType = Feature::TYPE_CHECK;
	public ?string $unit      = null;
	public int     $position  = 9999;
	public int     $decimals  = 0;
	public int     $isHidden  = 0;

	public ?float    $minValue        = null;
	public ?float    $maxValue        = null;
	protected ?float $currentMinValue = null;
	protected ?float $currentMaxValue = null;

	/** @var FilterItem[] */
	public array $items = [];

	/**
	 * @return FilterItem[]
	 */
	public function getItemsWithProducts(): array
	{
		$items = [];
		foreach ($this->items as $item) {
			if ($item->productsCount > 0) {
				$items[] = $item;
			}
		}

		return $items;
	}

	public function hasActive(): bool
	{
		foreach ($this->items as $item) {
			if ($item->isActive) {
				return true;
			}
		}

		return false;
	}

	public function setId(?int $id): void
	{
		$this->id = $id;
	}

	/**
	 * @param int|string|float $min
	 * @param int|string|float $max
	 */
	public function setMinMaxValue($min, $max): void
	{
		$this->minValue = (float) str_replace(',', '.', (string) $min);
		$this->maxValue = (float) str_replace(',', '.', (string) $max);
	}

	/**
	 * @param int|string|float $min
	 * @param int|string|float $max
	 */
	public function setMinMaxCurrentValue($min, $max): void
	{
		$this->currentMinValue = $min && $this->minValue != $min ? (float) str_replace(',', '.', (string) $min) : null;
		$this->currentMaxValue = $max && $this->maxValue != $max ? (float) str_replace(',', '.', (string) $max) : null;
	}

	public function getCurrentMinValue(): ?float { return $this->currentMinValue && $this->currentMinValue !== $this->minValue ? $this->currentMinValue : null; }

	public function getCurrentMaxValue(): ?float { return $this->currentMaxValue && $this->currentMaxValue !== $this->maxValue ? $this->currentMaxValue : null; }

}
