<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Helpers\Strings;

class Video
{
	protected ?string $title;
	protected ?string $url;
	protected ?string $lang = null;
	protected ?string $thumbnail;

	public function __construct(
		?string $title,
		?string $url,
		?string $lang = null,
		?string $thumbnail = null
	)
	{
		$this->title     = $title;
		$this->url       = $url;
		$this->lang      = $lang;
		$this->thumbnail = $thumbnail;
	}

	public function getTitle(): ?string
	{
		return $this->title;
	}

	public function getUrl(): ?string
	{
		return $this->url;
	}

	public function getThumbnail(): ?string
	{
		return $this->thumbnail;
	}

	public function getLang(): ?string { return $this->lang; }

	/**
	 * Zjisti, zda je url odkazem na mistni soubor nebo externim linkem (napr. youtube)
	 */
	public function isLocalFile(): bool
	{
		return !Strings::startsWith($this->url, 'http');
	}

}
