<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\AvailabilityService;
use Nette\Caching\Storage;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\SmartObject;

class AvailabilityListener implements EventSubscriberInterface
{
	use SmartObject;

	protected Cache $cache;
	protected Langs $langs;

	public function __construct(Storage $storage, Langs $langs)
	{
		$this->cache = new Cache($storage, AvailabilityService::CACHE_NAMESPACE);
		$this->langs = $langs;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param object             $entity
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($entity, $args): void
	{
		foreach ($this->langs->getLangs(false) as $lang) {
			$this->cache->remove('availabilities/' . $lang->getTag());
		}
	}

}