<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__availability_text")
 * @ORM\Entity
 */
class AvailabilityText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Availability", inversedBy="texts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Availability $availability;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=false)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $name;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $description = null;

	public function __construct(Availability $availability, string $lang, string $name)
	{
		$this->availability = $availability;
		$this->lang         = $lang;
		$this->name         = $name;
	}

}