<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__dynamic_feature_category")
 * @ORM\Entity
 * @ORM\EntityListeners({"EshopCatalog\Model\Listeners\DynamicFeatureCategoryListener"})
 */
class DynamicFeatureCategory
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="dynamicFeatures", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Category $category;

	/**
	 * @ORM\ManyToOne(targetEntity="Feature", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_feature", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Feature $feature;

	/**
	 * @ORM\Column(name="`value`", type="string", length=255, nullable=false)
	 */
	public string $value;

	public function __construct(
		Category $category,
		Feature  $feature,
		string   $value
	)
	{
		$this->category = $category;
		$this->feature  = $feature;
		$this->value    = $value;
	}
}
