<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__feature_texts", indexes={@ORM\Index(name="feature", columns={"id", "lang"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureListener"})
 */
class FeatureTexts
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="featureTexts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Feature $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	public string $name;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $internalName = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $beaUrlMulti = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $productTabTitle = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $heurekaName = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $zboziName = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $googleName = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $idealoName = null;

	public function __construct(Feature $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getFeature(): Feature { return $this->id; }

	public function getLang(): string
	{
		return $this->lang;
	}

}
