<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__manufacturer", indexes={
 *     @ORM\Index(name="id_name", columns={"id", "name"})
 * })
 * @ORM\Entity
 * @ORM\EntityListeners({"ManufacturerListener"})
 */
class Manufacturer
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	public string $name;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $logo = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $website = null;

	/**
	 * @ORM\Column(type="smallint", length=1)
	 */
	public int $isPublished;

	/**
	 * @var Collection<string, ManufacturerTexts>
	 * @ORM\OneToMany(targetEntity="ManufacturerTexts", mappedBy="id", indexBy="lang", cascade={"all"})
	 */
	protected Collection $texts;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	private int $position;

	public function __construct()
	{
		$this->texts       = new ArrayCollection;
		$this->isPublished = 1;
		$this->setPosition(-1);
	}

	public function getText(string $lang): ?ManufacturerTexts { return $this->texts->get($lang); }

	/**
	 * @return Collection<string, ManufacturerTexts>
	 */
	public function getTexts(): Collection { return $this->texts; }

	/******
	 * === Position
	 */

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getPosition(): int { return $this->position; }

}