<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__product_change_plan")
 */
class ProductChangePlan
{
	public const columnVatRate = 'vatRate';

	use TIdUnsigned;

	/**
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @ORM\Column(name="`column`", type="string", length=255)
	 */
	protected string $column;

	/**
	 * @ORM\Column(name="`value`", type="string", length=255)
	 */
	protected string $value;

	/**
	 * @ORM\Column(type="datetime")
	 */
	protected \DateTimeInterface $created;

	/**
	 * @ORM\Column(type="datetime")
	 */
	protected \DateTimeInterface $changeAt;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	protected ?\DateTimeInterface $changed = null;

	public function __construct(
		Product            $product,
		string             $column,
		string             $value,
		\DateTimeInterface $changeAt
	)
	{
		$this->product  = $product;
		$this->column   = $column;
		$this->value    = $value;
		$this->created  = new DateTime();
		$this->changeAt = $changeAt;
	}

	public function getColumn(): string { return $this->column; }

	public function getValue(): string { return $this->value; }

	public function getCreated(): \DateTimeInterface { return $this->created; }

	public function getChangeAt(): \DateTimeInterface { return $this->changeAt; }

	public function getChanged(): ?\DateTimeInterface { return $this->changed; }

	public function getProduct(): Product { return $this->product; }

	public function change(): void
	{
		$this->changed = new DateTime();
	}
}
