<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__product_supplier")
 */
class ProductSupplier
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="suppliers")
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Product $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Supplier", inversedBy="product")
	 * @ORM\JoinColumn(name="id_supplier", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Supplier $supplier;

	/**
	 * @ORM\Column(type="integer")
	 */
	public int $quantity;

	/**
	 * @var string
	 * @ORM\Column(type="string")
	 */
	public string $code;

	/**
	 * @ORM\ManyToOne(targetEntity="Availability")
	 * @ORM\JoinColumn(name="id_availability_after_sold_out", referencedColumnName="id", onDelete="SET NULL", nullable=true)
	 */
	public ?Availability $availabilityAfterSoldOut = null;

	/**
	 * @ORM\Column(type="smallint", length=1, options={"default": 1})
	 */
	public int $isActive = 1;

	/**
	 * @ORM\Column(type="smallint", length=1, options={"default": 0, "unsigned": true})
	 */
	public int $mainSupplier = 0;

	public function __construct(Product $product, Supplier $supplier)
	{
		if ($product->getSuppliers()->count() === 0) {
			$this->mainSupplier = 1;
		}

		$product->getSuppliers()->add($this);
		$this->product  = $product;
		$this->supplier = $supplier;
		$this->quantity = 0;
	}

	public function getProduct(): Product { return $this->product; }

	public function setSupplier(Supplier $supplier): void { $this->supplier = $supplier; }

	public function getSupplier(): Supplier { return $this->supplier; }

}