<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TIdUnsigned;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__product_supplier_skip")
 */
class ProductSupplierSkip
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $code;

	/**
	 * @ORM\ManyToOne(targetEntity="Supplier")
	 * @ORM\JoinColumn(name="id_supplier", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Supplier $supplier;

	public function __construct(string $code, Supplier $supplier)
	{
		$this->code     = $code;
		$this->supplier = $supplier;
	}
}
