<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__related_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class RelatedGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @ORM\Column(type="smallint", options={"default": 1})
	 */
	public int $isPublished = 1;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(type="integer")
	 */
	protected int $position = -1;

	/**
	 * @var Collection<string, RelatedGroupText>
	 * @ORM\OneToMany(targetEntity="RelatedGroupText", mappedBy="group", indexBy="lang", cascade={"persist", "remove"})
	 */
	protected Collection $texts;

	public function __construct()
	{
		$this->texts = new ArrayCollection;

		$this->setPosition(-1);
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getText(?string $lang = null): ?RelatedGroupText
	{
		return $this->texts[$lang ?: $this->locale];
	}

	/**
	 * @return Collection<string, RelatedGroupText>
	 */
	public function getTexts(): Collection { return $this->texts; }

	/**
	 * @param RelatedGroupText[] $texts
	 */
	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

}