<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__search_history")
 * @ORM\Entity
 */
class SearchHistory
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $text;

	/**
	 * @ORM\Column(type="date", nullable=false)
	 */
	public \DateTime $createdAt;

	/**
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	public Site $site;

	/**
	 * @ORM\Column(type="integer", nullable=false, options={"default": 0, "unsigned": true})
	 */
	public int $views = 0;

	public function __construct(
		Site   $site,
		string $text
	)
	{
		$this->site      = $site;
		$this->text      = $text;
		$this->createdAt = new \DateTime();
	}
}
