<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__supplier_texts")
 * @ORM\Entity
 */
class SupplierTexts
{
    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity="Supplier", inversedBy="SupplierTexts", cascade={"persist", "remove"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
     */
    private Supplier $id;

    /**
     * @ORM\Id
     * @ORM\Column(type="string", length=2)
     */
    private string $lang;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    public ?string $description = null;

    public function __construct(Supplier $id, string $lang)
    {
        $this->id = $id;
        $this->lang = $lang;
    }

    public function getLang(): string
	{
        return $this->lang;
    }

}