<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Listeners;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductPriceCountryHistory;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductPriceCountryHistoryListener implements EventSubscriberInterface
{
	protected CacheService $cacheService;

	public function __construct(
		CacheService $cacheService
	)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 */
	public function onPostPersist(ProductPriceCountryHistory $entity, LifecycleEventArgs $args): void
	{
		$this->cacheService->priceCache->remove('retailPriceCountry/' . $entity->country->getId() . '/' . $entity->product->getId());
	}

}