<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Entities\ExtraField;

class Packages
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function getEditablePackageIds(): array
	{
		$editablePackageIds = [];
		if (class_exists('EshopPackages\DI\EshopPackagesExtension')) {
			$qb = $this->em->getRepository(ExtraField::class)->createQueryBuilder('ef');
			$qb->select('ef.value')
			   ->andWhere('ef.key = :key')
			   ->andWhere('ef.lang IS NULL')
			   ->andWhere('ef.sectionName = :sn')
			   ->setParameters([
				   'key' => 'productId',
				   'sn'  => constant('EshopPackages\Model\Entities\EditablePackage::EXTRA_FIELD_SECTION'),
			   ]);

			foreach ($qb->getQuery()->getArrayResult() as $row) {
				$editablePackageIds[] = (int) $row['value'];
			}
		}

		return $editablePackageIds;
	}

}