<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200505071200 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE eshop_catalog__related_group (id INT AUTO_INCREMENT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, position INT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__related_group_text (lang VARCHAR(2) NOT NULL, group_id INT NOT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_CF735AADFE54D947 (group_id), PRIMARY KEY(group_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_catalog__related_product (id INT AUTO_INCREMENT NOT NULL, origin_id INT NOT NULL, product_id INT NOT NULL, group_id INT NOT NULL, INDEX IDX_7B7F5A4856A273CC (origin_id), INDEX IDX_7B7F5A484584665A (product_id), INDEX IDX_7B7F5A48FE54D947 (group_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_catalog__related_group_text ADD CONSTRAINT FK_CF735AADFE54D947 FOREIGN KEY (group_id) REFERENCES eshop_catalog__related_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__related_product ADD CONSTRAINT FK_7B7F5A4856A273CC FOREIGN KEY (origin_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__related_product ADD CONSTRAINT FK_7B7F5A484584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_catalog__related_product ADD CONSTRAINT FK_7B7F5A48FE54D947 FOREIGN KEY (group_id) REFERENCES eshop_catalog__related_group (id) ON DELETE CASCADE');
		$this->addSql('DROP TABLE eshop_catalog__related_products');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$conn = $this->connection;

		$conn->insert('eshop_catalog__related_group', [
			'is_published' => 1,
			'position'     => 0,
		]);
		$id = $conn->lastInsertId();
		$conn->insert('eshop_catalog__related_group_text', [
			'lang'     => 'cs',
			'group_id' => $id,
			'name'     => 'Související produkty',
		]);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_catalog__related_group_text DROP FOREIGN KEY FK_CF735AADFE54D947');
		$this->addSql('ALTER TABLE eshop_catalog__related_product DROP FOREIGN KEY FK_7B7F5A48FE54D947');
		$this->addSql('CREATE TABLE eshop_catalog__related_products (product_id INT NOT NULL, related_product_id INT NOT NULL, INDEX IDX_637279F34584665A (product_id), INDEX IDX_637279F3CF496EEA (related_product_id), PRIMARY KEY(product_id, related_product_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('ALTER TABLE eshop_catalog__related_products ADD CONSTRAINT FK_637279F34584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE eshop_catalog__related_products ADD CONSTRAINT FK_637279F3CF496EEA FOREIGN KEY (related_product_id) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('DROP TABLE eshop_catalog__related_group');
		$this->addSql('DROP TABLE eshop_catalog__related_group_text');
		$this->addSql('DROP TABLE eshop_catalog__related_product');
	}
}
