<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Variants;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\Model\Entities\VariantText;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\Variant;
use EshopCatalog\AdminModule\Model\Variants;

/**
 * Class VariantForm
 * @package EshopCatalog\AdminModule\Components\Variants
 */
class VariantForm extends BaseControl
{
	/** @var Variant */
	public $variant;

	/** @var Variants */
	protected $variantsServices;

	public function __construct(Variants $variants)
	{
		$this->variantsServices = $variants;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'eshopCatalog.variantForm.name')->setIsMultilanguage()
			->setMaxLength(255)->setRequired();
		$form->addBool('useAsFilter', 'eshopCatalog.variantForm.useAsFilter')->setDefaultValue(1);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$variant = $this->variant ?: new Variant();

			$variant->useAsFilter = $values->useAsFilter;

			$mTexts = $form->prepareMultilangTextsForEntity(['name'], $values);
			foreach ($mTexts as $lang => $vals) {
				$variantText = $variant->getText($lang) ?: new VariantText($variant, $lang);
				foreach ($vals as $k => $v)
					$variantText->$k = $v;

				$this->em->persist($variantText);
			}

			//TODO dodelat jetsli na barvu atd. jiné moznosti
			$variant->type        = 1;
			$variant->isPublished = $values->isPublished;

			$this->em->persist($variant);
			$this->em->flush();
			$form->addCustomData('variantId', $variant->getId());
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.variantForm.variantSaved');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ==================================   GET / SET
	 */
	public function setVariant($id)
	{
		$this->variant = $this->variantsServices->get($id);

		if ($this->variant) {
			$form = $this['form'];
			$form->setDefaults([
				'useAsFilter' => $this->variant->useAsFilter,
				'isPublished' => $this->variant->isPublished,
			]);

			$mTexts = $form->prepareMultilangTextsForForm(['name'], $this->variant->getTexts()->toArray());
			$form->setDefaults($mTexts['texts']);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}

