<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class ProductVariant
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Table(name="eshop_catalog__product_variant")
 * @ORM\Entity
 * @ORM\EntityListeners({"ProductVariantListener"})
 */
class ProductVariant
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var int
	 * @ORM\Column(name="is_default", type="smallint", length=1)
	 */
	public $isDefault;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="productVariants")
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $product;

	/**
	 * @var ProductVariantCombination[]
	 * @ORM\OneToMany(targetEntity="ProductVariantCombination", mappedBy="productVariant", indexBy="productVariant", cascade={"all"})
	 */
	protected $productCombinations;

	/**
	 * @var int
	 * @ORM\Column(name="quantity", type="integer")
	 */
	public $quantity;

	/**
	 * @var string
	 * @ORM\Column(name="ean", type="string", length=20, nullable=true)
	 */
	public $ean;

	/**
	 * @var string
	 * @ORM\Column(name="code1", type="string", length=60, nullable=true)
	 */
	public $code1;

	/**
	 * @var string
	 * @ORM\Column(name="code2", type="string", length=60, nullable=true)
	 */
	public $code2;

	/**
	 * @var double
	 * @ORM\Column(name="unit_price_impact", type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $unitPriceImpact;

	/**
	 * ProductVariant constructor.
	 *
	 * @param Product $product
	 */
	public function __construct(Product $product)
	{
		$this->product             = $product;
		$this->isDefault           = 0;
		$this->quantity            = 0;
		$this->productCombinations = new ArrayCollection();
	}

	/**
	 * @param ProductVariantCombination $pac
	 *
	 * @return $this
	 */
	public function addProductCombination(ProductVariantCombination $pac)
	{
		$this->productCombinations->add($pac);

		return $this;
	}

	/**
	 * @return ArrayCollection|ProductVariantCombination
	 */
	public function getProductCombinations() { return $this->productCombinations; }

	/**
	 * @return $this
	 */
	public function clearCombinations()
	{
		$this->productCombinations->clear();

		return $this;
	}
}
