document.addEventListener('click', e => {
	const el = e.target;
	const modalEl = el.closest('.modal');

	if (el.matches('.variant-box__value') && modalEl) {
		e.preventDefault();

		// Nastaveni ID produktu do komponenty kosiku
		modalEl.querySelector('.variant-modal [name="productId"]').value = el.dataset.id;

		modalEl.querySelectorAll('.variant-box__value').forEach(el => el.classList.remove('light-grey-bg-color'))
		el.classList.add('light-grey-bg-color');
		const variant    = {
			id         : el.dataset.id,
			price      : el.dataset.price,
			retailPrice: el.dataset.retailPrice,
			image      : el.dataset.image,
			name       : el.dataset.name,
		};
		const attributes = [];

		let retailPriceEl = modalEl.querySelector('.variant-modal__old-price');
		if (variant.retailPrice) {
			retailPriceEl.textContent = variant.retailPrice;
			retailPriceEl.classList.remove('hidden');
		} else {
			retailPriceEl.classList.add('hidden');
		}
		modalEl.querySelector('.variant-modal__price').textContent = variant.price;
		modalEl.querySelectorAll('.cart-add-wrap').forEach(el => {
			el.classList.add('hidden');
		});
		modalEl.querySelector('.cart-add-wrap[data-id="' + variant.id + '"]').classList.remove('hidden');

		const variantImg          = modalEl.querySelector('.variant-modal__left img');
		variantImg.setAttribute('src', variant.image);
		variantImg.setAttribute('alt', variant.name);
	}
});
