<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Model\Sites;
use Users\Model\Roles;

class SettingsForm extends DataForm
{
	/** @var Sites|null @inject */
	public ?Sites $sitesService = null;

	/** @var Roles|null @inject */
	public ?Roles $roles = null;

	public function getDataForInputs(): array
	{
		$data = parent::getDataForInputs();

		foreach ($this->sitesService->getOptionsForSelect() as $site) {
			$data[] = [
				'name'    => $site . 'RegisterUserSale',
				'title'   => [
					0 => 'eshopCatalog.settings.registerUserSale',
					null,
					['name' => $site],
				],
				'type'    => 'number',
				'step'    => .01,
				'min'     => 0,
				'default' => 0,
			];
			$data[] = [
				'name'  => $site . 'TermsAndConditionsNavId',
				'title' => [
					0 => 'eshopCatalog.settings.termsAndConditionsNavId',
					null,
					['name' => $site],
				],
				'type'  => 'text',
			];
			$data[] = [
				'name'  => $site . 'GdprNavId',
				'title' => [
					0 => 'eshopCatalog.settings.gdprNavId',
					null,
					['name' => $site],
				],
				'type'  => 'text',
			];
		}

		$data[] = [
			'name'  => 'disableRegisterUserSaleForRole',
			'title' => [
				0 => 'eshopCatalog.settings.disableRegisterUserSaleForRole',
			],
			'items' => $this->roles->getForSelectOptions(),
			'type'  => 'checkboxList',
		];

		return $data;
	}

}
