<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\ProductPrice;
use EshopCatalog\Model\Entities\ProductTag;

/**
 * @method ProductPrice|null|object = getReference($id)
 * @method ProductPrice[]|null getAll()
 */
class ProductPrices extends BaseEntityService
{
	protected $entityClass = ProductPrice::class;

	public function get(int $productId, string $country)
	{
		return $this->getEr()->findOneBy(['product' => $productId, 'country' => $country]);
	}
}
