<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use EshopCatalog\Model\Entities\Category;
use EshopCatalog\Model\Entities\CategoryRelated;
use Nette\Localization\Translator;

/**
 * @method CategoryRelated|null|object = getReference($id)
 * @method CategoryRelated[]|null getAll()
 * @method CategoryRelated|null get($id)
 */
class RelatedCategories extends BaseEntityService
{
	use TPosition;

	protected $entityClass = CategoryRelated::class;

	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	public function add(int $category, int $target, string $key = 'category'): ?CategoryRelated
	{
		try {
			$entity            = new CategoryRelated($this->em->getReference(Category::class, $category), $target);
			$entity->targetKey = $key;

			$this->em->persist($entity);
			$this->em->flush();

			return $entity;
		} catch (\Exception $e) {

		}

		return null;
	}

	public function getByCategory(int $id): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('cr')
			         ->where('cr.category = :id')
			         ->setParameter('id', $id)
			         ->orderBy('cr.position')
			         ->getQuery()->getArrayResult() as $row) {
			$arr[$row['id']] = $row;
		}

		return $arr;
	}
}
