<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Helpers\DocumentsHelper;

class Document
{
	/** @var string */
	protected string $name;

	/** @var string */
	protected string $file;

	/**
	 * Document constructor.
	 *
	 * @param string $name
	 * @param string $file
	 */
	public function __construct(string $name, string $file)
	{
		$this->name = $name;
		$this->file = $file;
	}

	/**
	 * @return bool
	 */
	public function isSecured(): bool { return DocumentsHelper::isSecured($this->file); }

	/**
	 * @return string
	 */
	public function getFilePath(): string { return $this->isSecured() ? '#' : $this->file; }

	/**
	 * @return string
	 */
	public function getName(): string { return $this->name; }
}
