<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Dao\Country;
use Nette\Utils\Html;

class Seller
{
	public int $id;

	/** @var string */
	public $title;

	/** @var string */
	public $name;

	/** @var string */
	public $street;

	/** @var string */
	public $city;

	/** @var string */
	public $postal;

	/** @var Country|null */
	public ?Country $country = null;

	/** @var string */
	public $street2;

	/** @var string */
	public $city2;

	/** @var string */
	public $postal2;

	/** @var Country|null */
	public ?Country $country2 = null;

	/** @var string */
	public $ic;

	/** @var string */
	public $dic;

	/** @var string */
	public $email;

	/** @var string */
	public $phone;

	/** @var BankAccount[] */
	protected array $bankAccounts = [];

	public bool $sendOrderToSeller = true;

	public bool $sendStatusToSeller = true;

	public string $sendSellerEmailType = 'seller';

	public function __construct(int $id)
	{
		$this->id = $id;
	}

	public function getBankAccount(?string $currency = null): ?BankAccount
	{
		if ($currency) {
			$currency = strtolower($currency);

			if (isset($this->bankAccounts[$currency]) && $this->bankAccounts[$currency]->numberPart1)
				return $this->bankAccounts[$currency];
		}

		$czk = $this->bankAccounts['czk'];

		return $czk ?? array_values($this->bankAccounts)[0];
	}

	public function addBankAccount(BankAccount $bankAccount): self
	{
		$this->bankAccounts[$bankAccount->currencyCode] = $bankAccount;

		return $this;
	}

	public function renderAddress(string $number = '', array $skip = []): Html
	{
		$wrap = Html::el();
		$rows = [];

		if ($this->{'street' . $number})
			$wrap->addHtml(Html::el('div')->setText($this->{'street' . $number}));

		$postal = $this->{'postal' . $number} ?? null;
		if ($this->{'city' . $number})
			$wrap->addHtml(Html::el('div')->setText(($postal ? $postal . ', ' : '') . $this->{'city' . $number}));

		if ($this->{'country' . $number} && !in_array('country', $skip))
			$wrap->addHtml(Html::el('div')->setText($this->{'country'}->getName()));

		return $wrap;
	}

	public function isVatPayer(): bool { return $this->dic ? true : false; }
}
