<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="eshop_catalog__feature_value_texts", indexes={@ORM\Index(name="feature_value", columns={"id", "lang"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureValueListener"})
 */
class FeatureValueTexts
{

	/**
	 * @var FeatureValue
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="FeatureValue", inversedBy="featureValueTexts")
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="text", nullable=true)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="rod_m", type="string", nullable=true)
	 */
	public $rodM;

	/**
	 * @var string
	 * @ORM\Column(name="rod_z", type="string", nullable=true)
	 */
	public $rodZ;

	/**
	 * @var string
	 * @ORM\Column(name="rod_s", type="string", nullable=true)
	 */
	public $rodS;

	public function __construct($id, $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	/**
	 * @return FeatureValue
	 */
	public function getFeatureValue() { return $this->id; }

	public function getLang()
	{
		return $this->lang;
	}

	public function setName($name)
	{
		$this->name = Strings::truncate($name, 255, '');

		return $this;
	}
}

