<?php declare(strict_types=1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__product_video")
 * @ORM\Entity
 */
class ProductVideo
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Column(type="string", length=2, nullable=true)
	 */
	public ?string $lang;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $url;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $title;

	public function __construct(Product $product, ?string $lang, ?string $url, ?string $title)
	{
		$this->product = $product;
		$this->lang = $lang;
		$this->url = $url;
		$this->title = $title;
	}

}