<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Model;

use Core\Model\Sites;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\Model\Config;

class CategoriesFeed
{
	protected Categories $categories;

	protected Sites $sites;

	public string $baseUrl = '';

	public function __construct(Categories $categories, Sites $sites)
	{
		$this->categories = $categories;
		$this->sites      = $sites;
	}

	public function getCategories(): array
	{
		$data   = [];
		$rootId = $this->categories->getRootIdForSite($this->sites->getCurrentSite()->getIdent());

		foreach ($this->categories->getCategories($rootId) as $category) {
			$hierarchyText = [$category->name];
			if ($category->getParentPath()) {
				foreach ($category->getParentPath() as $parent) {
					$hierarchyText[] = $parent->name;
				}
			}

			$item = [
				'category_id'    => $category->getId(),
				'title'          => $category->name,
				'link'           => $category->link,
				'image_link'     => $category->image ? ($this->baseUrl . ltrim($category->image, '/')) : '',
				'hierarchy_text' => array_reverse($hierarchyText),
			];

			if (Config::load('categoriesFeed.allowShortDescription')) {
				$item['shortDescription'] = $category->shortDescription;
			}

			if (Config::load('categoriesFeed.allowDescription')) {
				$item['description'] = $category->description;
			}

			$data[] = $item;
		}

		return $data;
	}
}
