<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Entities\Feature;

class FeatureProduct
{
	/** @var int */
	public $idProduct;

	/** @var int|string */
	public $idFeature;

	/** @var int|string */
	public $idFeatureValue;

	/** @var int */
	public $position;

	/** @var int */
	public $valuePosition;

	/** @var string */
	public $name;

	/** @var string */
	public $value;

	public ?string $rawValue = null;

	public ?string $unit = null;

	public string $type = Feature::TYPE_CHECK;

	public string $valueType = Feature::VALUE_TYPE_TEXT;

	public ?string $image = null;

	public bool $showAsTag = false;

	public ?string $tagTextColor = null;

	public ?string $tagBgColor = null;

	public ?string $productTabTitle = null;

	public ?string $tagText = null;

	public ?string $shortDescription = null;

	public ?string $longDescription = null;

	public ?string $moreLink = null;

	public int $useForVariantDiff = 1;

	public array $extraFields = [];

	public function getKey(): string { return $this->idFeature . '-' . ($this->idFeatureValue ?: $this->rawValue); }

	public function getTagStyle(): string
	{
		$arr = [];

		if ($this->tagTextColor)
			$arr[] = 'color:' . $this->tagTextColor;
		if ($this->tagBgColor)
			$arr[] = 'background-color:' . $this->tagBgColor;

		return implode(';', $arr);
	}

	public function setExtraFields(array $array): self
	{
		$this->extraFields = $array;

		return $this;
	}

	public function getExtraFields(): array { return $this->extraFields; }

	public function getExtraField(string $key, $default = null) { return $this->extraFields[$key] ?? $default; }
}
