<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class FeatureValueListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var CacheService */
	protected $cacheService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(CacheService $cacheService, ITranslator $translator)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param object             $entity
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($entity, $args)
	{
		foreach ($this->translator->getLocalesWhitelist() as $l) {
			$this->cacheService->defaultCache->remove('featureValues_' . $l);
			$this->cacheService->defaultCache->remove('featureValueTexts_' . $l);
		}

		$this->cacheService->defaultCache->remove('featureIdValues');
		$this->cacheService->defaultCache->clean([
			Cache::TAGS => ['featureValues'],
		]);
		$this->cacheService->filterCache->clean([
			Cache::TAGS => ['filters'],
		]);
	}
}
