document.addEventListener('DOMContentLoaded', () => {
	initCategoryFilter();
	initSiteSelect();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initSiteSelect();

		setTimeout(() => {
			initCategoryFilter();
		}, 5000);
		initCategoryFilter();
	});

	global.naja.addEventListener('complete', e => {
		initCategoryFilter();
	});
});

const initSiteSelect = () => {
};

const initCategoryFilter = () => {
	let productsGridForm = document.getElementById('frm-productsGrid-grid-filter');

	if (!productsGridForm)
		return;

	productsGridForm.querySelectorAll('[name="filter[defaultCategory]"]:not(.init)').forEach(el => {
		el.classList.add('init');

		el.addEventListener('change', () => {
			let data = new FormData(el.form);
			global.naja.makeRequest('post', el.form.action, data);
		});
	});
};
