import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"

let exportsLoaded  = [];
let exportsLastXhr = [];
const exportUrls   = {
	heureka: 'https://api-evidence.pshk.cz/v1/cms/heureka-export-categories',
	zbozi  : 'https://api-evidence.pshk.cz/v1/cms/zbozi-export-categories',
	google : 'https://api-evidence.pshk.cz/v1/cms/google-export-categories',
};

document.addEventListener('DOMContentLoaded', () => {
	initInputs();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initInputs();
	});

	global.naja.addEventListener('complete', e => {
		initInputs();
	});
});

const initInputs = () => {
	document.querySelectorAll('[data-grader-type]:not(.init)').forEach(input => {
		input.classList.add('init');
		let type    = input.dataset.graderType;
		let inputId = input.id;

		if (!exportUrls[type])
			return true;

		input.parentElement.style.position = 'relative';

		new autoComplete({
			data       : {
				src  : async () => {
					if (exportsLoaded[type])
						return exportsLoaded[type];

					if (typeof exportsLastXhr[type] !== 'undefined' && exportsLastXhr[type].hasOwnProperty('abort'))
						exportsLastXhr[type].abort();

					let source = await fetch(exportUrls[type], {
						method: 'GET',
					});

					const result = await source.json();

					exportsLastXhr[type] = [];
					for (let a in result.data) {
						let row   = result.data[a];
						let value = row;

						if (row.value)
							value = row.value;

						exportsLastXhr[type][a] = {
							name: value,
						};
					}
					return exportsLastXhr[type];
				},
				key  : ['name'],
				cache: true,
			},
			cache      : false,
			selector   : '#' + inputId,
			maxResults : 20,
			threshold  : 2,
			resultsList: {
				render     : true,
				destination: input,
				position   : "afterend",
				element    : "ul"
			},
			resultItem : {
				content: (data, source) => {
					source.innerHTML = data.index + ' | ' + data.value.name;
				},
				element: "li"
			},
			onSelection: feedback => {
				input.value = feedback.selection.value.name;
			}
		});
	});
};

if (document.readyState === "complete") {
	initInputs();
}
