document.addEventListener('DOMContentLoaded', () => {
	let inProcess = false;

	// Nastavení správných kategoriíí do selectu v navigaci
	document.addEventListener('change', e => {
		let target = e.target;

		if (target.id.indexOf('navigationForm-form-site') !== -1) {
			let categorySelect = target.form.querySelector('[name="component[category]"]');

			if (categorySelect && inProcess === false) {
				e.stopImmediatePropagation();
				inProcess = true;

				global.naja.makeRequest('post', categorySelect.dataset.customLink, {
					componentData: {
						site: target.value,
					},
				}, {
					history: false,
				}).complete(response => {
					inProcess = false;
				});
			}
		}
	});
});
