import autoComplete from "core/../node_modules/@tarekraafat/autocomplete.js/src/models/autoComplete"


document.addEventListener('DOMContentLoaded', () => {
	initInputs();
	initRelatedProductRemoveButtons();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initInputs();
	});

	global.naja.addEventListener('complete', e => {
		initInputs();
	});
});

const initInputs = () => {
	let input = document.getElementById('product-finder');
	let inputId = input.id;

	input.parentElement.style.position = 'relative';

	new autoComplete({
		data: {
			src: async () => {
				let source = await fetch(input.dataset.link, {
					method: 'GET',
				});

				let data = await source.json();

				let result = [];
				for (let a in data) {
					let row = data[a];
					result[row.id] = {
						name: row.name.toLowerCase(),
						id: row.id ? row.id.toString().toLowerCase() : null,
						ean: row.ean ? row.ean.toString().toLowerCase() : null,
						code1: row.code1 ? row.code1.toString().toLowerCase() : null,
					};
				}

				return result;
			},
			key: ['name', 'id', 'ean', 'code1'],
			cache: true,
		},
		cache: false,
		selector: '#' + inputId,
		maxResults: 20,
		threshold: 0,
		resultsList: {
			render: true,
			destination: input,
			position: "afterend",
			element: "ul"
		},
		resultItem: {
			content: (data, source) => {
				let name = data.value.name;
				name = name.charAt(0).toUpperCase() + name.slice(1);
				let val = name;
				if (data.value.code1) {
					val += ' | ' + data.value.code1;
				}
				source.innerHTML = val;
			},
			element: "li"
		},
		onSelection: feedback => {
			let id = feedback.selection.index;
			let name = feedback.selection.value.name;
			name = name.charAt(0).toUpperCase() + name.slice(1);
			let template = '<tr><td>'+name+'</td><td class="fit-content"><a href="#" class="btn btn-danger btn-remove-related-product"><i class="fas fa-trash"></i></a><input type="hidden" value="'+id+'" name="relatedProductIds[]" /></td></tr>';

			let productDuplicated = false;
			document.querySelectorAll('input[name*=relatedProductIds]').forEach(el => {
				if (el.value == id) {
					productDuplicated = true;
				}
			});

			if (!productDuplicated) {
				document.querySelector("#related-products tbody").innerHTML += template;
				initRelatedProductRemoveButtons();
			}
			input.value = null;
		}
	});
};

const initRelatedProductRemoveButtons = () => {
	document.querySelectorAll('.btn-remove-related-product').forEach(el => {
		el.addEventListener('click', e => {
			e.stopPropagation();
			el.closest('tr').remove();

			let link = el.dataset.removeLink;
			let id = el.dataset.id;

			if (id) {
				window.naja.makeRequest('post', link, {
					relatedProductId: id
				}, {
					history: false
				});
			}
		});
	});
};

if (document.readyState === "complete") {
	initInputs();
	initRelatedProductRemoveButtons();
}