import noUiSlider from 'nouislider'
import {slideDown, slideUp} from "es6-slide-up-down";
import {checkMedia} from './utilities/utitlities'
import {addEventForChild} from '../../../../../core/assets/admin/src/js/utils/Functions';

document.addEventListener('DOMContentLoaded', () => {
	/**
	 * Inicializace price filtru pro ProductsFilter.latte
	 */
	initPriceRange();

	/**
	 * Inicializace po requestu
	 */
	global.naja.addEventListener('complete', e => {
		console.log('complt');
		initPriceRange();
		initVariantPopupChange();
	});

	/**
	 * Skryvani a odkryvani filtru na responzivni verzi
	 */
	document.querySelectorAll('[data-show-filter]').forEach(el => {
		el.addEventListener('click', () => {
			const id = el.dataset.showFilter;
			const parent = el.parentNode;
			const targetElement = parent.querySelector(`[data-filter-group="${id}"]`);
			if (!targetElement.classList.contains('active')) {
				slideDown(targetElement);
				targetElement.classList.add('active');
			} else {
				slideUp(targetElement);
				targetElement.classList.remove('active');
			}
		});
	});

	/**
	 * Skryvani a odkryvani pomoci zobrazit dalsi
	 * TODO temporary fix for IE SlideDown / Up
	 */
	document.querySelectorAll('[data-show-more]').forEach(el => {
		el.addEventListener('click', () => {
			const targetEl = el.parentNode.querySelector('[data-hidden-content]');
			if (!targetEl.classList.contains('active')) {
				targetEl.style.display = "block";
				targetEl.classList.add('active');
				el.classList.add('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.hide;
			} else {
				targetEl.style.display = "none";
				targetEl.classList.remove('active');
				el.classList.remove('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.show;
			}
		});
	});

	/**
	 * Popup na varianty funkce
	 */
	addEventForChild(document.querySelector('body'), 'click', '.variant-box__value', (el) => {
		document.querySelectorAll('.variant-box__value').forEach(el => el.classList.remove('light-grey-bg-color'))
		el.classList.add('light-grey-bg-color');
		const variant = {
			price: el.dataset.price,
			retailPrice: el.dataset.retailPrice,
			image: el.dataset.image,
			name: el.dataset.name,
		};
		const attributes = [];
		document.querySelector('.variant-modal__old-price').textContent = variant.retailPrice;
		document.querySelector('.variant-modal__price').textContent = variant.price;
		const variantImg = document.querySelector('.variant-modal__left img');
		variantImg.attributes.src = variant.image;
		variantImg.attributes.alt = variant.name;
	});


});

const initPriceRange = () => {
	let slider = document.getElementById('price-slider');

	if (!slider || slider.classList.contains('init'))
		return;

	slider.classList.add('init');

	const min = Math.round(slider.dataset.min);
	const max = Math.round(slider.dataset.max);
	const start = Math.round(slider.dataset.start);
	const end = Math.round(slider.dataset.end);
	const parent = slider.parentNode;
	const input0 = parent.querySelector('#input-with-keypress-0');
	const input1 = parent.querySelector('#input-with-keypress-1');
	const inputs = [input0, input1];

	noUiSlider.create(slider, {
		start: [min, max],
		range: {min: start, max: end},
		tooltips: [true, true],
		format: {
			to: function (value) {
				return Math.round(value) + ' Kč'
			},
			from: function (value) {
				return Number(value.replace(',-', ''));
			}
		}
	});

	slider.noUiSlider.on('change', function (values, handle, unencoded, tap, positions) {
		document.querySelector('[name="priceRange[min]"]').value = parseInt(unencoded[0]);
		document.querySelector('[name="priceRange[max]"]').value = parseInt(unencoded[1]);

		let link = slider.dataset.updateLink.replace('__min__', parseInt(unencoded[0])).replace('__max__', parseInt(unencoded[1]));
		global.naja.makeRequest('get', link, [], {
			history: true,
		});

	});

	slider.noUiSlider.on('update', function (values, handle, rawValue, bool, percentageValue) {
		inputs[handle].innerHTML = values[handle];
	});
};

const initVariantPopupChange = () => {
	document.querySelectorAll('.variant-box__value:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('click', e => {
			e.preventDefault();

			// Nastaveni ID produktu do komponenty kosiku
			document.querySelector('.variant-modal [name="productId"]').value = el.dataset.id;

			return false;
		});
	});
}
